#!/bin/bash
export LANG=C
WORKDIR=$(cd $(dirname $0) && pwd)
LOGFILE=${WORKDIR}/backup_status.log
[ ! -f ${LOGFILE} ] && touch ${LOGFILE}
loginfo(){
  echo -e "[$(date +'%Y-%m-%d %H:%M:%S')] $*" >> ${LOGFILE}
}

if [ x$(whoami) != 'xgbabsedbt' ]; then
  loginfo "Not user gbasedbt!"
  exit 1
fi

if [ ! -f ~gbasedbt/.bash_profile ]; then
  loginfo "Env file .bash_profile not found!"
  exit 2
fi

. ~gbasedbt/.bash_profile

DBSTATUS=$(onstat -|grep 'On-Line'|wc -l)
if [ ${DBSTATUS:-0} -eq 0 ]; then
  loginfo "Dbstatus not online!"
  exit 3
fi
TAPEDEV=$(onstat -c TAPEDEV)
if [ ! -d ${TAPEDEV} ]; then
  loginfo "TAPEDEV not exists!"
  exit 4
fi
loginfo "Delete old backup file."
cd ${TAPEDEV} && find . -name "*L0*" -mtime +7 | xargs rm -f 2>/dev/null

loginfo "Begin backup database...."
ontape -s -L 0 2>/dev/null
STATUS=$?

if [ ! ${STATUS:-0} -eq 0 ]; then
  loginfo "Backup error, with code ${STATUS}."
  exit 5
fi
loginfo "Finish backup database."

loginfo "Begin gzip backup file...."
cd ${TAPEDEV} && find . -name "*L0" | xargs gzip 2>/dev/null
logingo "Finish gzip backup file."

exit 0