#!/bin/bash
# filename: ziptape[.sh]
# function: zip and encrypt ontape
# write by: liaosnet@gbasedbt.com 2023-12-28
#
export LANG=C
loginfo(){
  echo -e "[$(date +'%Y-%m-%d %H:%M:%S')] $*"
}
usage(){
  cat <<!

ziptape[.sh]

Usage:
{ 
  -r [-t tape_device_path [-P password]] | 
  -s [[-L archive_level] [-t tape_device_path] [-P password]]}

-r Full restore
-s Archive full system

!
}

## get parameter
if [[ $# -eq 0 ]]; then
  usage
  exit 1
fi
while [[ $# -gt 0 ]]
do
  key="$1"
  case $key in
    -r) OPT="r";          shift ;;
    -s) OPT="s";          shift ;;
    -t) TAPEDEV="$2";     shift; shift ;;
    -L) LEVEL="$2";       shift; shift ;;
    -P) PASSWORD="$2";    shift; shift ;;
     *) usage;            exit  1 ;;
  esac
done

if [[ x"${OPT}" = "xs" && x"${LEVEL}" = x ]]; then
  read -p "Please enter the level of archive to be performed (0, 1, or 2) " -s LEVEL
  if [[ x"${LEVEL}" = x || ! "0,1,2" =~ ${LEVEL} ]]; then
    echo ""
    cat <<!
Archive failed - function invalid archive level failed code -1 errno 0 

Program over.
!
    exit 1
  fi
fi

OPT=${OPT:-s}
TAPEDEV=${TAPEDEV:-}

onstat - >>/dev/null 2>&1
DBSTATUS=$?
if [ x"${TAPEDEV}" = x ]; then
  TAPEDEV=$(onstat -c TAPEDEV |tail -n 1)
fi
if [ ! -d ${TAPEDEV} ]; then
  echo "  TAPEDEV is not directory !"
  exit 2
fi
if [ ! -x ${TAPEDEV} ]; then
  echo "  TAPEDEV is not writable !"
  exit 3
fi
if [ x"${PASSWORD}" = x ]; then
  OPTPSW=""
else 
  OPTPSW=" -P ${PASSWORD}"
fi

SERVERNUM=$(onstat -c SERVERNUM | tail -n 1)
HOSTNAME=$(hostname)
FILENAME=${HOSTNAME}_${SERVERNUM:-0}

if [ x"${OPT}" = xs ]; then
  if [ ! ${DBSTATUS:-0} -eq 5 ];then
    echo "  Database not On-Line mode !"
    exit 1
  fi
  [ -f ${TAPEDEV}/${FILENAME}_L${LEVEL}.zip ] && MVNEED=1
  if [ ${MVNEED:-0} -eq 1 ]; then
    FILETIME=$(ls -l --time-style '+%Y%m%d_%H%M%S' ${TAPEDEV}/${FILENAME}_L${LEVEL}.zip | awk '{print $6}')
    BAKFILENAME=${FILENAME}_${FILETIME}_L${LEVEL}
    mv ${TAPEDEV}/${FILENAME}_L${LEVEL}.zip ${TAPEDEV}/${BAKFILENAME}.zip
  fi
  loginfo "Start level ${LEVEL} backup and zip ..."
  ontape -s -L ${LEVEL} -t STDIO | zip -r ${OPTPSW} ${TAPEDEV}/${FILENAME}_L${LEVEL}.zip - >>/dev/null 2>&1
  RC=$?
  loginfo "Finish level ${LEVEL} backup and zip."
# only restore L0
elif [ x"${OPT}" = xr ]; then
  if [ ! ${DBSTATUS:-0} -eq 255 ];then
    echo "  Database is not Off-Line mode, can not restore !"
    exit 1
  fi
  [ -f ${TAPEDEV}/${FILENAME}_L0.zip ] && L0NEED=1
  if [ ${L0NEED:-0} -eq 1 ]; then
    loginfo "Start level 0 restore..."
    unzip -p ${OPTPSW} ${TAPEDEV}/${FILENAME}_L0.zip | ontape -r -t STDIO >>/dev/null 2>&1
    RC=$?
    if [ ${RC} -eq 0 ]; then
      loginfo "Finish level 0 restore."
      loginfo "You MUST change the database status use 'onmode -m'."
    fi
  else
    loginfo "Backup file ${TAPEDEV}/${FILENAME}_L0.zip not exists !"
    RC=5
  fi
fi

exit ${RC}
